package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.VfichaOs3Dao;
import com.ejie.ab04b.model.VfichaOs3;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VfichaOs3ServiceImpl generated by UDA, 26-jun-2017 14:21:02.
 * 
 * @author UDA
 */

@Service(value = "vfichaOs3Service")
public class VfichaOs3ServiceImpl implements VfichaOs3Service {

	@Autowired
	private VfichaOs3Dao vfichaOs3Dao;

	/**
	 * Inserts a single row in the VfichaOs3 table.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaOs3 the vficha os 3
	 * @return the vficha os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaOs3 add(VfichaOs3 vfichaOs3) {
		return this.vfichaOs3Dao.add(vfichaOs3);
	}

	/**
	 * Updates a single row in the VfichaOs3 table.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaOs3 the vficha os 3
	 * @return the vficha os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public VfichaOs3 update(VfichaOs3 vfichaOs3) {
		return this.vfichaOs3Dao.update(vfichaOs3);
	}

	/**
	 * Finds a single row in the VfichaOs3 table.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *  VfichaOs3
	 *
	 * @param vfichaOs3 the vficha os 3
	 * @return the vficha os 3
	 */
	public VfichaOs3 find(VfichaOs3 vfichaOs3) {
		return (VfichaOs3) this.vfichaOs3Dao.find(vfichaOs3);
	}

	/**
	 * Deletes a single row in the VfichaOs3 table.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *
	 * @param vfichaOs3 the vficha os 3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(VfichaOs3 vfichaOs3) {
		this.vfichaOs3Dao.remove(vfichaOs3);
	}

	/**
	 * Finds a list of rows in the VfichaOs3 table.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VfichaOs3>
	 *
	 * @param vfichaOs3 the vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<VfichaOs3> findAll(VfichaOs3 vfichaOs3,
			JQGridRequestDto jqGridRequestDto) {
		return (List<VfichaOs3>) this.vfichaOs3Dao.findAll(vfichaOs3,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the VfichaOs3 table using like.
	 * 
	 *  vfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VfichaOs3>
	 *
	 * @param vfichaOs3 the vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<VfichaOs3> findAllLike(VfichaOs3 vfichaOs3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<VfichaOs3>) this.vfichaOs3Dao.findAllLike(vfichaOs3,
				jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the VfichaOs3 table.
	 * 
	 *  filterVfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterVfichaOs3 the filter vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(VfichaOs3 filterVfichaOs3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.vfichaOs3Dao.removeMultiple(filterVfichaOs3, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the VfichaOs3 table.
	 * 
	 *  filterVfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<VfichaOs3>
	 *
	 * @param filterVfichaOs3 the filter vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<VfichaOs3> filter(VfichaOs3 filterVfichaOs3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<VfichaOs3> listaVfichaOs3 = this.vfichaOs3Dao.findAllLike(
				filterVfichaOs3, jqGridRequestDto, false);
		Long recordNum = this.vfichaOs3Dao.findAllLikeCount(
				filterVfichaOs3 != null ? filterVfichaOs3 : new VfichaOs3(),
				false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<VfichaOs3>> reorderSelection = this.vfichaOs3Dao
					.reorderSelection(filterVfichaOs3, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<VfichaOs3>(jqGridRequestDto,
					recordNum, listaVfichaOs3, reorderSelection);
		}
		return new JQGridResponseDto<VfichaOs3>(jqGridRequestDto, recordNum,
				listaVfichaOs3);
	}

	/**
	 * Searches rows in the VfichaOs3 table.
	 * 
	 *  filterVfichaOs3
	 *            VfichaOs3
	 *  searchVfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<VfichaOs3>>
	 *
	 * @param filterVfichaOs3 the filter vficha os 3
	 * @param searchVfichaOs3 the search vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<VfichaOs3>> search(VfichaOs3 filterVfichaOs3,
			VfichaOs3 searchVfichaOs3, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.vfichaOs3Dao.search(filterVfichaOs3, searchVfichaOs3,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in VfichaOs3 table.
	 * 
	 *  filterVfichaOs3
	 *            VfichaOs3
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterVfichaOs3 the filter vficha os 3
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(VfichaOs3 filterVfichaOs3,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.vfichaOs3Dao.reorderSelection(filterVfichaOs3,
				jqGridRequestDto, startsWith);
	}

}
